<?php

namespace Drupal\ckeditor_media_title\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Plugin\CKEditor5PluginConfigurableInterface;
use Drupal\ckeditor5\Plugin\CKEditor5PluginConfigurableTrait;
use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\ckeditor5\Plugin\CKEditor5PluginElementsSubsetInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\editor\EditorInterface;

/**
 * CKEditor 5 Media Title plugin.
 *
 * @CKEditor5Plugin(
 *   id = "ckeditor_media_title_mediaImageTitle",
 *   ckeditor5 = @CKEditor5AspectsOfCKEditor5Plugin(
 *     plugins = {"mediaTitle.MediaTitle"},
 *     config = {}
 *   ),
 *   drupal = @DrupalAspectsOfCKEditor5Plugin(
 *     label = @Translation("Media Image Title Override"),
 *     library = "ckeditor_media_title/media_title",
 *     elements = false,
 *     conditions = {
 *       "filter" = "media_embed"
 *     }
 *   )
 * )
 */
class MediaTitle extends CKEditor5PluginDefault implements CKEditor5PluginConfigurableInterface, CKEditor5PluginElementsSubsetInterface {

  use CKEditor5PluginConfigurableTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'enabled' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable media image title override'),
      '#description' => $this->t('When enabled, a button will appear in the media toolbar to override the title attribute of embedded images.'),
      '#default_value' => $this->configuration['enabled'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
    // No validation needed.
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['enabled'] = (bool) $form_state->getValue('enabled');
  }

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    // Only add the toolbar button if enabled.
    if ($this->configuration['enabled']) {
      return [
        'drupalMedia' => [
          'toolbar' => ['mediaImageTitle'],
        ],
      ];
    }

    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getElementsSubset(): array {
    if ($this->configuration['enabled']) {
      return ['<drupal-media title>'];
    }
    return [];
  }

}
