<?php

namespace Drupal\ckeditor_mentions\Events;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Provides a Ckeditor mentions suggestion event.
 *
 * @package Drupal\ckeditor_mentions
 */
class CKEditorMentionSuggestionsEvent extends Event implements CKEditorMentionSuggestionEventInterface {

  /**
   * CKEditorMentionSuggestionsEvent constructor.
   *
   * @param string $keyword
   *   The keyword  used by the user.
   * @param array $suggestions
   *   Suggestions.
   */
  public function __construct(protected string $keyword, protected array $suggestions = []) {
  }

  /**
   * {@inheritDoc}
   */
  public function getKeyword(): string {
    return $this->keyword;
  }

  /**
   * {@inheritDoc}
   */
  public function getSuggestions(): array {
    return $this->suggestions;
  }

  /**
   * {@inheritDoc}
   */
  public function setSuggestions(array $suggestions) {
    $this->suggestions = $suggestions;
  }

}
