<?php

namespace Drupal\ckeditor_mentions\Events;

use Drupal\ckeditor_mentions\MentionsType\MentionsTypeInterface;
use Drupal\Core\Entity\EntityInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Class provide the mention event.
 *
 * @package Drupal\ckeditor_mentions
 */
class CKEditorMentionsEvent extends Event implements CKEditorMentionEventInterface {

  /**
   * CKEditorMentionsEvent constructor.
   */
  public function __construct(
    protected EntityInterface $entity,
    protected EntityInterface $mentionedEntity,
    protected MentionsTypeInterface $plugin,
  ) {
  }

  /**
   * {@inheritDoc}
   */
  public function getEntity(): EntityInterface {
    return $this->entity;
  }

  /**
   * {@inheritDoc}
   */
  public function setEntity(EntityInterface $entity) {
    $this->entity = $entity;
  }

  /**
   * {@inheritDoc}
   */
  public function getMentionedEntity(): EntityInterface {
    return $this->mentionedEntity;
  }

  /**
   * {@inheritDoc}
   */
  public function setMentionedEntity(EntityInterface $mentioned_user) {
    $this->mentionedEntity = $mentioned_user;
  }

  /**
   * {@inheritDoc}
   */
  public function getPlugin(): MentionsTypeInterface {
    return $this->plugin;
  }

  /**
   * {@inheritDoc}
   */
  public function setPlugin(MentionsTypeInterface $mentionsType) {
    $this->plugin = $mentionsType;
  }

}
