<?php

declare(strict_types=1);

namespace Drupal\ckeditor_mentions\Plugin\CKEditor4To5Upgrade;

use Drupal\ckeditor5\HTMLRestrictions;
use Drupal\ckeditor5\Plugin\CKEditor4To5UpgradePluginInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\filter\FilterFormatInterface;

/**
 * Provides the CKEditor 4 to 5 upgrade path for mentions plugin.
 *
 * @CKEditor4To5Upgrade(
 *   id = "ckeditor_mentions",
 *   cke4_buttons = {},
 *   cke4_plugin_settings = {
 *     "mentions",
 *   },
 *   cke5_plugin_elements_subset_configuration = {}
 * )
 */
class MentionsUpgrade extends PluginBase implements CKEditor4To5UpgradePluginInterface {

  /**
   * {@inheritdoc}
   */
  public function mapCKEditor4ToolbarButtonToCKEditor5ToolbarItem(string $cke4_button, HTMLRestrictions $text_format_html_restrictions): ?array {
    throw new \OutOfBoundsException();
  }

  /**
   * {@inheritdoc}
   */
  public function mapCKEditor4SettingsToCKEditor5Configuration(string $cke4_plugin_id, array $cke4_plugin_settings): ?array {
    return match ($cke4_plugin_id) {
      'mentions' => [
        'ckeditor_mentions_mentions' => [
          'plugins' => [
            $cke4_plugin_settings['mentions_type'] ?? 'user' => [
              'marker' => $cke4_plugin_settings['marker'],
              'charcount' => $cke4_plugin_settings['charcount'],
              'dropdownLimit' => 10,
              'enable' => $cke4_plugin_settings['enable'] ?? FALSE,
            ],
          ],
        ],
      ],
      default => throw new \OutOfBoundsException(),
    };
  }

  /**
   * {@inheritdoc}
   */
  public function computeCKEditor5PluginSubsetConfiguration(string $cke5_plugin_id, FilterFormatInterface $text_format): ?array {
    throw new \OutOfBoundsException();
  }

}
