/**
 * Provides a class that handles ajax connection with Drupal.
 */
export default class MentionsAjax {

  constructor(options) {
    this.options = options;
  }

  /**
   * Initialize Mentions ajax object.
   */
  static initialize(options) {
    const me = new MentionsAjax(options);

    return queryString => me.getFeedItems(queryString);
  }

  /**
   * Renders item.
   */
  static itemRender(item) {
    const itemWrapper = document.createElement('span');
    const text = document.createElement('span');
    const image = document.createElement('img');

    itemWrapper.classList.add('ck-list__item--wrapper');

    text.innerText = item.text;
    text.classList.add('ck-list__item--text');

    if (item.avatar) {
      image.src = item.avatar;
      itemWrapper.appendChild(image);
    }
    itemWrapper.appendChild(text);

    return itemWrapper;
  }

  /**
   * Fetches feeds.
   */
  getFeedItems(queryText) {
    return new Promise(resolve => {
      setTimeout(async () => {
        let itemsToDisplay = fetch(this.options.url.replace('--match--', queryText))
          .then((response) => response.json())
          .then((data) => this.prepareData(data));

        resolve(itemsToDisplay);
      }, 100);
    });
  }

  /**
   * Prepares items data.
   */
  prepareData(items) {
    items.forEach((item) => {
      item.id = this.options.marker + item.entity_id;
      item.text = this.options.removeMarker ? item.label : this.options.marker + item.label;
      item.link = item.url ?? '';
      item.plugin = this.options.type;
      return item;
    });
    return items;
  }

}
