<?php

namespace Drupal\ckeditor_mentions\Plugin\MentionsType;

use Drupal\ckeditor_mentions\MentionsType\MentionsTypeBase;
use Drupal\Core\Database\Query\AlterableInterface;
use Drupal\node\NodeInterface;

/**
 * Provides a node mentions type.
 *
 * @MentionsType(
 *   id = "node",
 *   label = @Translation("Node"),
 *   entity_type = "node"
 * )
 */
class Node extends MentionsTypeBase {

  /**
   * {@inheritDoc}
   */
  public function getQuery(): AlterableInterface {
    $query = $this->entityManager
      ->getStorage($this->getPluginDefinition()['entity_type'])
      ->getQuery()
      ->condition('title', $this->getMatch(), 'CONTAINS')
      ->condition('status', NodeInterface::PUBLISHED)
      ->accessCheck();

    return $query;
  }

}
