<?php

namespace Drupal\ckeditor_standalone_styles;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining CKEditor style entities.
 */
interface CKEditorStyleInterface extends ConfigEntityInterface {

  /**
   * Returns text from the classes field.
   *
   * @return string
   *   A string of classes.
   */
  public function getClasses();

  /**
   * Returns the HTML element this style applies to.
   *
   * @return string
   *   The HTML element type, e.g. "div" or "span".
   */
  public function getElement();

}
