<?php

namespace Drupal\ckeditor_standalone_styles;

use Drupal\Core\Config\Entity\DraggableListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of CKEditor Styles entities.
 */
class CKEditorStyleListBuilder extends DraggableListBuilder {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ckeditor_styles_admin_overview_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Label');
    $header['machine_name'] = $this->t('Machine name');
    $header['element'] = $this->t('Element');
    $header['classes'] = $this->t('Classes');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row = [];
    $row['label'] = $entity->label();
    $row['machine_name'] = ['#plain_text' => $entity->id()];
    $row['type'] = ['#plain_text' => $entity->getElement()];
    $row['classes'] = ['#plain_text' => $entity->getClasses()];
    return $row + parent::buildRow($entity);
  }

}
