<?php

namespace Drupal\ckeditor_standalone_styles\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\ckeditor_standalone_styles\CKEditorStyleInterface;

/**
 * Defines the CKEditorStyle config entity.
 *
 * @ConfigEntityType(
 *   id = "ckeditor_style",
 *   label = @Translation("CKEditor Style"),
 *   label_collection = @Translation("CKEditor Styles"),
 *   label_plural = @Translation("CKEditor Styles"),
 *   handlers = {
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider"
 *     },
 *     "list_builder" = "Drupal\ckeditor_standalone_styles\CKEditorStyleListBuilder",
 *     "form" = {
 *       "add" = "Drupal\ckeditor_standalone_styles\Form\CKEditorStyleForm",
 *       "edit" = "Drupal\ckeditor_standalone_styles\Form\CKEditorStyleForm",
 *       "delete" = "Drupal\ckeditor_standalone_styles\Form\CKEditorStyleDeleteForm"
 *     }
 *   },
 *   config_prefix = "style",
 *   admin_permission = "administer ckeditor standalone styles",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "weight" = "weight",
 *     "uuid" = "uuid"
 *   },
 *   config_export = {
 *     "id" = "id",
 *     "label" = "label",
 *     "classes" = "classes",
 *     "element" = "element",
 *     "weight" = "weight",
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/content/ckeditor_style/{ckeditor_style}/edit",
 *     "delete-form" = "/admin/config/content/ckeditor_style/{ckeditor_style}/delete",
 *     "collection" = "/admin/config/content/ckeditor_style",
 *     "add-form" = "/admin/config/content/ckeditor_style/add"
 *   }
 * )
 */
class CKEditorStyle extends ConfigEntityBase implements CKEditorStyleInterface {

  /**
   * The CKEditor Style ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The CKEditor Style label.
   *
   * @var string
   */
  protected $label;

  /**
   * A string containing the classes, one per line.
   *
   * @var string
   */
  protected $classes;

  /**
   * A string indicating the HTML element type.
   *
   * @var string
   */
  protected $element;

  /**
   * Order of style in the styles dropdown.
   *
   * @var int
   */
  protected $weight = 0;

  /**
   * {@inheritdoc}
   */
  public function getClasses() {
    return $this->classes;
  }

  /**
   * {@inheritdoc}
   */
  public function getElement() {
    return $this->element;
  }

}
