<?php

namespace Drupal\ckeditor_standalone_styles\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Plugin\CKEditor5Plugin\Style as CoreStyle;
use Drupal\ckeditor_standalone_styles\CKEditorStylesHelper;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\editor\EditorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Extend core's Style plugin to integrate with our style definition storage.
 */
class Style extends CoreStyle implements ContainerFactoryPluginInterface {

  public function __construct(array $configuration, $plugin_id, $plugin_definition, protected CKEditorStylesHelper $ckeditorStylesHelper) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('ckeditor_standalone_styles.helper')
    );
  }

  /**
   * {@inheritDoc}
   */
  public function getElementsSubset(): array {
    // Problem: FundamentalCompatibilityConstraintValidator fails to allow
    // saving a format/filter combo because we're returning too large a subset
    // of elements. We need to only return elements that are allowed by the
    // editor already, but since we don't have the editor object, we can't
    // find that out. That constraint thinks things are wacky because this
    // plugin says supports elements that the filter format doesn't.
    $styles = $this->ckeditorStylesHelper->generateStyleSetSettingsDataCkeditor5();
    $elementsSubset = [];
    foreach ($styles as $styleInfo) {
      $elementsSubset[] = sprintf('<%s class="%s">', $styleInfo['element'], implode(' ', $styleInfo['classes']));
    }
    return $elementsSubset;
  }

  /**
   * {@inheritDoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    // Build style plugin's definitions list based on our module's list of
    // defined styles from config.
    // Limit the style definitions to only those that this editor's filter
    // format allows. Otherwise CKE5 will present the styles for elements that
    // cannot even be used.
    $allowedElementsFromFilterFormat = [];
    $filterFormatHtmlRestrictions = $editor->getFilterFormat()->getHtmlRestrictions();
    if (is_array($filterFormatHtmlRestrictions)) {
      $allowedElementsFromFilterFormat = array_keys($filterFormatHtmlRestrictions['allowed']);
    }
    return [
      'style' => [
        'definitions' => $this->ckeditorStylesHelper->generateStyleSetSettingsDataCkeditor5($allowedElementsFromFilterFormat),
      ],
    ];
  }

}
