<?php

namespace Drupal\ckeditor_tippy\Plugin\Filter;

use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;

/**
 * Provides a custom text filter.
 *
 * @Filter(
 *   id = "tippy_filter",
 *   title = @Translation("Insert Popper when tippy is present"),
 *   description = @Translation("Popper is inserted only on pages where ckeditor_tippy is used"),
 *   type = Drupal\filter\Plugin\FilterInterface::TYPE_MARKUP_LANGUAGE
 * )
 */
class TippyFilter extends FilterBase {

  /**
   * {@inheritdoc}
   */
  public function process($text, $langcode) {
    // Check if the text contains <tippy> elements.
    if (strpos($text, '</tippy>') !== FALSE) {
      $result = new FilterProcessResult($text);
      if(file_exists(DRUPAL_ROOT . '/libraries/popperjs/dist/umd/popper.min.js')) {
        $result->setAttachments([
          'library' => ['ckeditor_tippy/popper_local', 'ckeditor_tippy/tippyjs'],
        ]);
      }
      else {
        $result->setAttachments([
          'library' => ['ckeditor_tippy/popper_remote', 'ckeditor_tippy/tippyjs'],
        ]);
      }

      return $result;
    }

    return new FilterProcessResult($text);
  }

  /**
   * {@inheritdoc}
   */
  public function tips($long = FALSE) {
    return $this->t('Popper is inserted only on pages where ckeditor_tippy is used.');
  }
}
