<?php

declare(strict_types = 1);

namespace Drupal\ckeditor_tippy\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\Core\Url;
use Drupal\editor\EditorInterface;

/**
 * Plugin class to add dialog url for ckeditor tippy tooltip.
 */
class TippyTooltip extends CKEditor5PluginDefault {

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    // Set dialogue URL.
    $embedded_content_dialog_url = Url::fromRoute('ckeditor_tippy.tippy_tooltip_dialog', [
      'editor' => $editor->id(),
    ])->toString(TRUE)->getGeneratedUrl();
    $static_plugin_config['tippyTooltip']['dialogURL'] = $embedded_content_dialog_url;

    return $static_plugin_config;
  }

}
