import {Plugin} from 'ckeditor5/src/core';
import {toWidget, Widget} from 'ckeditor5/src/widget';

import {createTooltipElement} from './utils';
import AddTooltipCommand from './commands/addtooltipcommand';

export default class Tippytooltip_editing extends Plugin {
  /**
   * @inheritdoc
   */
  static get requires() {
    return [Widget];
  }

  /**
   * @inheritdoc
   */
  init() {
    this._defineScheme();
    this._defineConverters();

    this.editor.commands.add('add-tooltip', new AddTooltipCommand(this.editor));
  }

  /**
   * Define where the tooltip can be used.
   */
  _defineScheme() {
    const {schema} = this.editor.model;
    schema.extend('$text', {allowAttributes: 'data-tippy-content'});
  }

  /**
   * Define the data conversions required when moving the tooltip between html
   * and the format ckeditor uses.
   */
  _defineConverters() {
    const {editor} = this;

    editor.conversion.for('dataDowncast').attributeToElement({
      model: 'data-tippy-content',
      view: createTooltipElement,
    });

    editor.conversion.for('editingDowncast').attributeToElement({
      model: 'data-tippy-content',
      view: (data, writer) => {
        return createTooltipElement(data, writer);
      },
    });

    editor.conversion
      .for('editingDowncast')
      .elementToElement(
        {
          model: 'data-tippy-content',
          view: (modelElement, {writer}) => {
            const container = writer.createContainerElement('figure');
            return toWidget(
              container, writer, {
                label: Drupal.t('Tippy'),
              },
            );

          },
        },
      );

    editor.conversion.for('upcast').elementToAttribute({
      view: {
        name: 'tippy',
        classes: 'tippy-tooltip-text',
        attributes: {
          'data-tippy-content': true,
        },
      },
      model: {
        key: 'data-tippy-content',
        value: (viewElement) => viewElement.getAttribute('data-tippy-content'),
      },
    });
  }
}
