
(function (Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.ckeditorTweetThis = {
    attach: function (context) {
      // Use standard querySelectorAll to find elements within the context
      // The context ensures the behavior only runs on new elements.
      const selector = 'a.tweetthis:not(.processed), a[href*="twitter.com/intent/tweet"]';

      context.querySelectorAll(selector).forEach(function (element) {

        // Get settings and current href
        let via = drupalSettings.twitterprofiler || drupalSettings.sitename;
        let tweetUrl = element.getAttribute('href');

        // Get the current visible text of the anchor tag.
        const currentLinkText = element.textContent.trim();

        // Find the index where the actual tweet text starts ("?text=")
        const textParamIndex = tweetUrl.indexOf('?text=');

        if (textParamIndex !== -1) {
          // Strip everything from the current URL after the "?text=" parameter.
          // This leaves only the base URL: 'http://twitter.com/intent/tweet?text='
          tweetUrl = tweetUrl.substring(0, textParamIndex + 6);

          // Append the anchor tag's text, ensuring it is URL-encoded.
          tweetUrl += encodeURIComponent(currentLinkText);
        } else {
          // Fallback: If ?text= is somehow missing, ensure the text is appended.
          // This handles cases where the link might just be the base URL.
          tweetUrl += '?text=' + encodeURIComponent(currentLinkText);
        }

        // Encode the current page URL
        const encodedUrl = encodeURIComponent(window.location.href);

        // Construct the full tweet URL (using '&url=' and '&via=')
        // Note: The base link now ends with the encoded tweet text.
        tweetUrl += '&url=' + encodedUrl + '&via=' + via;

        // Update the link attributes
        element.setAttribute('href', tweetUrl);
        element.classList.add('processed');
        element.setAttribute('target', '_blank');
      });
    }
  };
}(Drupal, drupalSettings));
