(function () {
  CKEDITOR.plugins.add('videoimce', {
    icons: 'video',
    requires: 'dialog',
    init: function (editor) {

      CKEDITOR.dialog.add('videoimceDialog', this.path + 'dialogs/videoimce.js');

      editor.addCommand('videoimce', new CKEDITOR.dialogCommand('videoimceDialog', {
        allowedContent: 'video[autoplay,controls,crossorigin,height,loop,poster,preload,style,width];source[src,type]',
        requiredContent: 'video'
      }));

      editor.ui.addButton('VideoImce', {
        label: 'Video',
        command: 'videoimce',
        toolbar: 'insert'
      });

      // Edit on double-click.
      editor.on('doubleclick', function (evt) {
        var el = evt.data.element;
        var videoEl = null;
        if (!el) return;

        if (el.is('video')) {
          videoEl = el;
        }
        else if (el.is('source') && el.getParent() && el.getParent().is('video')) {
          videoEl = el.getParent();
        }
        else if (el.getAttribute && el.getAttribute('data-cke-realelement')) {
          try {
            var real = editor.restoreRealElement(el);
            if (real && real.is && real.is('video')) {
              videoEl = real;
            }
          } catch (e) {}
        }

        if (videoEl) {
          editor._videoimceSelectedElement = videoEl;
          evt.data.dialog = 'videoimceDialog';
          evt.data.element = videoEl;
        }
      });
    }
  });
})();
