﻿<?php

namespace Drupal\ckeditor_video_imce\Plugin\CKEditorPlugin;

use Drupal\ckeditor\CKEditorPluginBase;
use Drupal\ckeditor\CKEditorPluginButtonsInterface;
use Drupal\Core\Extension\ModuleExtensionList;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\editor\Entity\Editor;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Upload video with IMCE.
 *
 * @CKEditorPlugin(
 *   id = "videoimce",
 *   label = @Translation("Video (IMCE)")
 * )
 */
class VideoImce extends CKEditorPluginBase implements CKEditorPluginButtonsInterface, ContainerFactoryPluginInterface {

  /**
   * The module extension list.
   *
   * @var \Drupal\Core\Extension\ModuleExtensionList
   */
  protected ModuleExtensionList $moduleExtensionList;

  /**
   * Constructs a VideoImce plugin instance.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Extension\ModuleExtensionList $module_extension_list
   *   The module extension list service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, ModuleExtensionList $module_extension_list) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->moduleExtensionList = $module_extension_list;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('extension.list.module')
    );
  }

  /**
   * Returns the module path.
   */
  protected function modulePath(): string {
    return $this->moduleExtensionList->getPath('ckeditor_video_imce');
  }

  /**
   * {@inheritdoc}
   */
  public function getFile(): string {
    return $this->modulePath() . '/js/plugins/videoimce/plugin.js';
  }

  /**
   * {@inheritdoc}
   */
  public function getButtons(): array {
    $path = $this->modulePath();
    return [
      'VideoImce' => [
        'label' => $this->t('Video'),
        'image' => $path . '/js/plugins/videoimce/icons/videoimce.png',
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getConfig(Editor $editor): array {
    return [
      'extraAllowedContent' => 'video[autoplay,controls,crossorigin,height,loop,poster,preload,style,width];source[src,type]',
    ];
  }

}
