# CL Preview

A Drupal-native component library browser for previewing Single Directory Components (SDC). A great alternative to Storybook that works entirely within Drupal without requiring Node.js, Webpack, or any external build tools.

## Features

- **Component Library Browser** - Organized interface with component navigation and live previews
- **Preview Values** - Define custom preview values in component.yml for better demos
- **Custom Code Examples** - Add @examples tags in Twig templates for custom multi-variant examples
- **Render Mode Selection** - Choose between @examples snippets or preview values for iframe rendering
- **No Story Files** - No need for .stories.yml, .stories.json, or MDX files
- **Theme Switching** - Preview components in any installed theme
- **Auto-Discovery** - Automatically finds all SDC components from configured themes/modules
- **Component Metadata** - View props, slots, status, and provider in a structured table
- **Code Examples** - Auto-generated Twig include code, or custom examples via @examples tag
- **No Build Step** - Pure Drupal, no Node.js/Webpack/Storybook setup needed

## Requirements

- Drupal 10.1+ (for SDC support)
- `sdc` module (Drupal core)
- `cl_editorial` module (for NoThemeComponentManager)

## Installation

1. Enable the module:
   ```bash
   drush en cl_preview -y
   ```

2. Grant permissions:
   - **Access CL component library** - For users who should view components
   - **Administer CL Preview settings** - For users who should configure the module

3. Configure the module:
   - Go to `/admin/config/development/cl-preview`
   - Select themes/modules to scan for components
   - Choose a preview theme (optional)
   - Select how to group components

## Usage

### Viewing the Component Library

Navigate to `/admin/config/development/cl-preview` to see all available components organized by provider and category.

### Component Preview

Click on any component in the sidebar to view:
- **Metadata table** - Provider, status, and component ID in a structured table
- **Live preview** - Rendered component with preview values or @examples snippets in an iframe
- **Props table** - View all props with types, preview values, and descriptions (read-only)
- **Slots table** - Available content slots with descriptions
- **Code example** - Copy-paste Twig code with preview values or custom @examples

### Preview Values

Define custom preview values in your component's `.component.yml` file to provide better default content for previews:

```yaml
$schema: https://git.drupalcode.org/project/drupal/-/raw/10.1.x/core/modules/sdc/src/metadata.schema.json
name: Button
props:
  type: object
  properties:
    variant:
      type: string
      title: Button Variant
      default: primary
      enum:
        - primary
        - secondary
        - danger
    text:
      type: string
      title: Button Text
      default: ''
    disabled:
      type: boolean
      default: false

# Define custom preview values for better demos
preview:
  variant: primary
  text: Click Me
  disabled: false
```

### Multiple Preview Variations

CL Preview supports defining **multiple preview variations** in a single component. This allows you to showcase different use cases, configurations, or states of your component side-by-side.

To define multiple preview variations, use an **array of preview objects** instead of a single object:

```yaml
$schema: https://git.drupalcode.org/project/drupal/-/raw/10.1.x/core/modules/sdc/src/metadata.schema.json
name: Typography
props:
  type: object
  properties:
    tag:
      type: string
      title: HTML Tag
      default: 'p'
      enum:
        - h1
        - h2
        - h3
        - h4
        - h5
        - h6
        - p
        - span
    content:
      type: string
      title: Content
      default: ''

# Multiple preview variations
preview:
  - tag: 'h1'
    content: 'This is a Heading 1'
  - tag: 'h2'
    content: 'This is a Heading 2'
  - tag: 'p'
    content: 'This is a paragraph example'
```

**How it works:**
- The preview page will display a **dropdown selector** allowing users to switch between variations
- Each variation is labeled automatically based on meaningful properties (tag, variant, type, etc.) or falls back to "Variation 1", "Variation 2", etc.
- The iframe preview automatically updates when a different variation is selected
- This works seamlessly with hot reload - file changes update the current variation

**Automatic labeling:**
CL Preview intelligently generates labels for each variation by looking for these properties (in order of priority):
1. `tag` - e.g., "H1", "H2"
2. `variant` - e.g., "Primary", "Secondary"
3. `type` - e.g., "Button", "Link"
4. `style` - e.g., "Outline", "Solid"
5. `size` - e.g., "Large", "Small"
6. `color` - e.g., "Primary", "Danger"
7. `title` - First 30 characters of the title
8. Fallback - "Variation N"

**Example with Button component:**

```yaml
name: Button
props:
  type: object
  properties:
    variant:
      type: string
    size:
      type: string
    text:
      type: string

preview:
  - variant: 'primary'
    size: 'large'
    text: 'Primary Button'
  - variant: 'secondary'
    size: 'medium'
    text: 'Secondary Button'
  - variant: 'outline'
    size: 'small'
    text: 'Outline Button'
```

This will create a dropdown with labels: "Primary", "Secondary", "Outline" (automatically derived from the `variant` property).

**Preview Value Hierarchy:**

The module uses the following hierarchy to determine what values to display in the preview:

1. **`preview` section** (highest priority) - Top-level preview values defined in the component.yml
2. **`default` property** - Default values defined within each prop's properties
3. **Type-based fallback** (lowest priority) - Empty values based on prop type (empty string, 0, false, [], etc.)

**Example:**
```yaml
props:
  type: object
  properties:
    title:
      type: string
      default: 'Default Title'  # Used if no preview value exists
    description:
      type: string
      # No default - will use empty string ''

# These preview values override the defaults above
preview:
  title: 'Welcome to Our Component'  # Overrides 'Default Title'
  description: 'This is a sample description for the preview'  # Overrides empty string
```

Preview values take precedence over default values and provide better examples in the component library. The code examples will always show these preview values, ensuring consistent documentation.

### Custom Code Examples with @examples Tag

In addition to auto-generated code examples, you can define custom examples directly in your component's Twig template using the `@examples` tag. This is especially useful when:

- Your component uses variables not defined in `component.yml` (e.g., shared components across multiple sites)
- You want to show multiple usage examples with different configurations
- The auto-generated example doesn't properly showcase the component
- You need more complex examples that demonstrate specific features

**How to add custom examples:**

Add a Twig comment with the `@examples` tag at the top of your component's `.twig` file:

```twig
{# @examples

Example Title 1

{% include 'theme_name:component-name' with {
  prop1: 'value1',
  prop2: true,
  prop3: ['item1', 'item2']
} %}

Example Title 2

{% include 'theme_name:component-name' with {
  prop1: 'different_value',
  prop2: false
} %}

#}
```

**Example structure:**
- The tag must be inside a Twig comment: `{# @examples ... #}`
- Each example can have an optional title/description (plain text line before the code)
- Code blocks use standard Twig `{% include %}` syntax
- Multiple examples are automatically detected and displayed separately

**Real-world example for a button component:**

```twig
{#
/**
 * @file
 * Template for a button component.
 */
#}

{# @examples

Primary Button

{% include 'wsp_radix:a-button' with {
  button_html_tag: 'button',
  color: 'primary',
  content: 'Click Me'
} %}

Link Button (Anchor)

{% include 'wsp_radix:a-button' with {
  button_html_tag: 'a',
  url: '/about',
  color: 'secondary',
  content: 'Learn More'
} %}

Outline Button

{% include 'wsp_radix:a-button' with {
  color: 'primary',
  outline: true,
  size: 'btn-lg',
  content: 'Get Started'
} %}

#}

{% apply spaceless %}
  {# Component template code here #}
{% endapply %}
```

**Example for a carousel component (with arrays):**

```twig
{# @examples

Single Banner

{% include 'wsp_radix:o-banner-carousel' with {
  backgroundColor: '#073689',
  showArrows: true,
  banners: [
    {
      banner_image_mobile: {
        src: 'https://picsum.photos/720/900',
        alt: 'Mobile Banner'
      },
      title_description: {
        title: 'Welcome',
        paragraphs: ['Explore our products']
      }
    }
  ]
} %}

Multiple Banners

{% include 'wsp_radix:o-banner-carousel' with {
  banners: [
    { banner_image_mobile: { src: '/img1.jpg' } },
    { banner_image_mobile: { src: '/img2.jpg' } }
  ]
} %}

#}
```

**Fallback behavior:**
- If a component has an `@examples` tag, those custom examples will be displayed
- If no `@examples` tag is found, cl_preview automatically generates examples from the `component.yml` props
- This means you can add custom examples only where needed, and other components continue working normally

**Benefits of custom examples:**
- **Completeness** - Show all variables needed for rendering, even if not in `component.yml`
- **Documentation** - Examples live next to the template code for easy maintenance
- **Multiple variants** - Demonstrate different use cases and configurations
- **Flexibility** - Each site can have custom examples without modifying shared `component.yml` files

### Hot Reload

The hot reload feature automatically refreshes component previews when you make changes to component files, providing instant feedback during development.

**How it works:**
- Polls the server every 1 second to check for file modifications
- Monitors these file types:
  - `.twig` - Template changes
  - `.css` - Stylesheet changes
  - `.js` - JavaScript changes
  - `.component.yml` - Configuration changes
- When changes are detected, the preview iframe automatically reloads
- Shows a brief notification when the preview is refreshed

**Configuration:**

1. **Global Default** (Settings page):
   - Navigate to `/admin/config/development/cl-preview/settings`
   - Check "Enable hot reload by default" to enable for all components
   - This sets the initial state for all component preview pages

2. **Per-Component Toggle** (Preview page):
   - Each component preview page has a "Enable Hot Reload" checkbox
   - Toggle it on/off to control hot reload for that specific component
   - Your preference persists while viewing that component

3. **Manual Refresh**:
   - When hot reload is disabled, a "Refresh Preview" button appears
   - Click this button to manually reload the preview iframe
   - Useful when you want control over when previews update

**Use cases:**
- **Development** - Keep hot reload enabled for instant feedback while editing
- **Documentation** - Disable hot reload when reviewing/documenting components
- **Performance** - Disable hot reload to reduce server polling if needed
- **Demonstrations** - Use manual refresh when presenting to avoid unexpected changes

**Technical details:**
- Polling interval: 1 second (1000ms)
- Uses `filemtime()` to detect file modifications
- Lightweight JSON endpoint: `/cl-preview/check-updates/{plugin_id}`
- No page reload required - only the iframe refreshes

### Configuration

**Settings** (`/admin/config/development/cl-preview`):

1. **Preview Theme**
   - Select which theme to use for rendering components
   - Leave empty to use the default site theme

2. **Scan Themes**
   - Check themes to scan for SDC components
   - Components from selected themes will appear in the library

3. **Scan Modules**
   - Check modules to scan for SDC components
   - Useful for contrib/custom modules with components

4. **Group Components By**
   - **Directory structure** - Groups by Atoms, Molecules, Organisms (from folder names)
   - **Theme/Module name** - Groups by provider
   - **Status** - Groups by stable, experimental, deprecated

5. **Preview Render Mode**
   - **Preview values** - Use preview values defined in component.yml (or defaults if not specified)
   - **Example snippets** - Use custom Twig examples defined with @examples tag in the component template (falls back to preview values if no @examples tag exists)

6. **Hot Reload**
   - Enable/disable automatic preview refresh when component files change
   - Default setting applies to all components (can be configured in settings)
   - Can be toggled per-component via checkbox on individual preview pages
   - Monitors changes to .twig, .css, .js, and .component.yml files
   - When disabled, a "Refresh Preview" button appears for manual refresh

## Permissions

- `access cl preview` - View the component library
- `administer cl preview` - Configure module settings

## Routes

- `/admin/config/development/cl-preview` - Component library (main page)
- `/admin/config/development/cl-preview/component/{plugin_id}` - Individual component preview
- `/admin/config/development/cl-preview/settings` - Settings page
- `/cl-preview/iframe/{plugin_id}` - Component iframe (for isolated rendering)

## Why CL Preview is a Great Alternative to Storybook

CL Preview provides a native Drupal alternative to Storybook without the complexity of external tooling:

1. **No Build Step** - No Webpack, Node.js, Yarn, or npm configuration required
2. **No Separate Installation** - Works entirely within Drupal, no additional servers or deployments
3. **No Story Files** - No need to create or maintain .stories.yml, .stories.json, or MDX files
4. **Auto-Discovery** - Components are automatically discovered from your existing .component.yml files
5. **Native Integration** - Uses Drupal's render system and SDC directly
6. **Theme Switching** - Preview in any installed theme without additional configuration
7. **Render Mode Options** - Choose between @examples snippets or preview values for rendering
8. **Preview Values** - Define custom preview data directly in component.yml files
9. **Access Control** - Built-in Drupal permissions and routing
10. **Easy Deployment** - Just enable the module, no separate build or deployment process

## Extending

### Custom Component Grouping

Override `ComponentDiscoveryService::getGroupKey()` to implement custom grouping logic.

### Additional Metadata

Extend the component preview controller to display additional metadata from component definitions.

## Troubleshooting

### No components showing

1. Check that you've selected themes/modules in settings
2. Verify those themes/modules have SDC components (components/ directory with *.component.yml files)
3. Clear cache: `drush cr`

### Permission denied

Grant the "Access CL component library" permission to your user role.

### Components not rendering

Check that the preview theme (if set) is installed and enabled.

### Empty or broken preview display

If your component preview appears empty or broken:

1. **Check preview values** - The component may have empty or poorly configured preview values
2. **Add preview section** - Define proper preview values in your `*.component.yml` file:
   ```yaml
   preview:
     title: Example Title
     description: Example description text
     items: ['Item 1', 'Item 2']
   ```
3. **Check prop defaults** - Ensure props have meaningful default values
4. **Review required props** - Components may require specific props to render properly
5. **Look for warnings** - The preview page highlights props with empty preview values in red

### Preview not rendering correctly

1. Check the preview rendering mode in settings (examples vs preview values)
2. For @examples mode, verify your @examples tag syntax in the Twig template
3. For preview values mode, ensure preview values are defined in component.yml
4. Check browser console for JavaScript errors
