<?php

namespace Drupal\cl_preview\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new RouteSubscriber object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Get the configured preview theme.
    $config = $this->configFactory->get('cl_preview.settings');
    $preview_theme = $config->get('preview_theme');

    // Set the theme for the iframe route if configured.
    if ($preview_theme && $route = $collection->get('cl_preview.iframe')) {
      $route->setOption('_theme', $preview_theme);
    }
  }

}
