<?php

namespace Drupal\cleaner\Commands;

use Drupal\Core\Logger\LoggerChannelInterface;
use Drush\Commands\DrushCommands;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Drupal\cleaner\Event\CleanerRunEvent;

/**
 * A Drush commandfile for Cleaner module.
 */
class CleanerCommands extends DrushCommands {

  /**
   * The event dispatcher service.
   *
   * @var EventDispatcherInterface
   */
  protected $eventDispatcher;

  /**
   * The logger channel.
   *
   * @var LoggerChannelInterface
   */
  protected $loggerChannel;

  /**
   * Constructs a new CleanerCommands object.
   *
   * @param EventDispatcherInterface $eventDispatcher
   *   The event dispatcher service.
   * @param LoggerChannelFactoryInterface $loggerFactory
   *   The logger factory.
   */
  public function __construct(EventDispatcherInterface $eventDispatcher, LoggerChannelFactoryInterface $loggerFactory) {
    $this->eventDispatcher = $eventDispatcher;
    $this->loggerChannel = $loggerFactory->get('cleaner');
  }

  /**
   * Run the cleaner tasks manually.
   *
   * @command cleaner:run
   * @aliases clean
   * @usage cleaner:run
   *   Run all cleaner tasks immediately.
   */
  public function run(): void {
    $this->logger()->notice('Starting Cleaner tasks...');

    try {
      // Dispatch the cleaner run event.
      $event = new CleanerRunEvent();
      $this->eventDispatcher->dispatch($event, CleanerRunEvent::CLEANER_RUN);

      $this->logger()->success('Cleaner tasks completed successfully.');
    }
    catch (\Exception $e) {
      $this->logger()->error('An error occurred while running cleaner tasks: ' . $e->getMessage());
    }
  }

}
