let player;

class ClipPlayer extends AbstractClipPlayer {
  pause() {
    player.pause();
  }

  play() {
    player.play();
  }

  isPlaying() {
    return player.paused() === false;
  }

  setPlaybackRate(rate) {
    player.playbackRate(rate);
  }

  seekToSecond(second) {
    player.currentTime(second);
  }

  seekToTimecode(timecode) {
    player.currentTime(this.getTime(timecode));
  }

  getVolume() {
    return player.volume();
  }

  setVolume(volume) {
    player.volume(volume);
  }

  getCurrentTime() {
    return player.currentTime();
  }
}

(function ($, Drupal) {
  Drupal.behaviors.clipVideoJsPlayer = {
    attach: function (context, settings) {
      if (context === document) {
        player = videojs('player', {
          autoplay: true,
          preload: "auto",
          playbackRates: [0.25, 0.5, 0.75, 1, 1.25, 1.5, 1.75, 2],
          responsive: false,
          techOrder: ['youtube'],
          youtube: {
            ytControls: false,
            customVars: {
              modestbranding: 1,
              rel: 0,
              iv_load_policy: 3,
              showinfo: 0,
              controls: 0,
              disablekb: 1,
              enablejsapi: 1,
              fs: 0,
              autoplay: 0,
              mute: 0,
            }
          },
          sources: [
            {
              type: "video/youtube",
              src: Drupal.behaviors.clipMediaEntityEditForm.getVideoSourceUrl().href,
            },
          ],
        }, Drupal.behaviors.clipMediaEntityEditForm.onPlayerAttach);

        player.on('playing', function () {
          Drupal.behaviors.clipMediaEntityEditForm.onPlayerPlay();
        });

        player.on('pause', function () {
          Drupal.behaviors.clipMediaEntityEditForm.onPlayerPause();
        });
      }
    }
  }
})(jQuery, Drupal);
