<?php
namespace Drupal\entity_clone_revision\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Overrides the NodeController class.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  public function alterRoutes(RouteCollection $collection) {
    // Override the original controller class with your custom controller class.
    if ($route = $collection->get('entity.node.version_history')) {
      $route->setDefault('_controller', '\Drupal\entity_clone_revision\Controller\NodeController::revisionOverview');
    }
  }
}
