<?php

namespace Drupal\clone_entity_revision\Controller;

use Drupal\Core\Url;
use Drupal\node\NodeInterface;
use Drupal\node\Controller\NodeController as CoreNodeController;

class NodeController extends CoreNodeController {

  /**
   * {@inheritdoc}
   */
  public function revisionOverview(NodeInterface $node) {
    $build = parent::revisionOverview($node);
    if (!empty($build['node_revisions_table']['#rows'])) {
      $rows = $build['node_revisions_table']['#rows'];
      $node = $this->entityRepository->getActive($node->getEntityTypeId(), $node->id());
      $langcode = $node->language()->getId();
      $node_storage = $this->entityTypeManager()->getStorage('node');
      foreach ($this->getRevisionIds($node, $node_storage) as $key => $vid) {
        $revision = $node_storage->loadRevision($vid);
        if ($revision->hasTranslation($langcode) && $revision->getTranslation($langcode)->isRevisionTranslationAffected()) {
          foreach ($rows[$key] as &$values) {
            if (is_array($values)) {
              foreach ($values as &$value_item) {
                if (is_array($value_item) && isset($value_item['#links']) && $this->currentUser()->hasPermission('clone_entity_revision.clone')) {
                  $value_item['#links']['clone'] = [
                    'title' => $this->t('Clone'),
                    'url' => Url::fromRoute('clone_entity_revision.revision_clone_confirm', ['node' => $node->id(), 'node_revision' => $vid]),
                  ];
                }
              }
            }
          }
        }
      }
      $build['node_revisions_table']['#rows'] = $rows;
    }
    return $build;
  }

}
