## About

Module to invalidate the CloudFront cache when Drupal content
changes. Suitable for small sites.

## How it works

Stand-alone module for CloudFront cache invalidation: as soon as
Drupal wants to invalidate the cache, immediately invalidate the
entire CloudFront cache. The goal is ease of setup.

## Configuration

You cannot provide AWS credentials in this module, we assume your
setup has access to credentials either via the AWS Metadata Service or
via environment variables.

You usually would set your distribution id in your `settings.php` like:

```php
$config['cloudfront_invalidate_all.settings']['distribution_id'] = getenv('DISTRIBUTION_ID');
```

So it is injected via an environment variable. Or you can hard-code
it, or save it to config.

### Black lists

Many cache invalidation tags are irrelevant and should not clear
CloudFront. There's a preconfigured comprehensive black list
installed, and this can be changed in the settings form.

## Why not use the purge module?

The purge module is very complicated and requires many more bits. Out
of the box it does not work for with CloudFront. You can install the
[CloudFront purger](www.drupal.org/project/cloudfront_purger) but that
will also not help you. The [URL queuer
addition](https://www.drupal.org/project/purge_queuer_url) does not
work properly.

So you are left with having to write mappings from Drush cache tags to
paths yourself. For smaller sites you don't really need that.

## Does this work for large sites?

No. Small sites, thousands of urls are fine. For large sites you want
the purge module and write custom code to map cache invalidation tags
to CloudFront paths.
