# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Overview

This is a Drupal module that invalidates the entire AWS CloudFront cache whenever Drupal's cache is invalidated. It's designed for small sites that need simple CloudFront cache invalidation without the complexity of the Purge module ecosystem.

## Development Commands

```bash
# Install dependencies
composer install

# Linter, code standards check
composer cs

# Fix code standards automatically
composer cs:fix
```

## Architecture

The module implements a simple cache invalidation strategy:

1. **Service Integration**: The module registers `cloudfront_invalidate_all.invalidator` as a Drupal service that implements `CacheTagsInvalidatorInterface` and is tagged as `cache_tags_invalidator`.

2. **CloudFrontInvalidator Class** (src/CloudFrontInvalidator.php):
   - Core logic that listens for Drupal cache tag invalidation events
   - Uses a configurable whitelist to only trigger invalidations for specific cache tags
   - Creates a wildcard invalidation (/*) on CloudFront when whitelisted cache tags are invalidated

3. **Configuration**:
   - Settings stored in `cloudfront_invalidate_all.settings`
   - Requires: `distribution_id` (CloudFront distribution ID)
   - Optional: `region` (defaults to us-east-1)
   - Uses a whitelist of cache tag prefixes (default: `node_list` and `node:`)
   - Settings form available at: Configuration > Web services > CloudFront Invalidate All

4. **AWS Credentials**: The module assumes AWS credentials are available via the AWS Metadata Service or environment variables - no credential configuration within the module itself.

## Key Design Decisions

- **Wildcard Invalidation**: Always invalidates /* rather than specific paths for simplicity
- **Whitelist Approach**: Uses a tag whitelist to explicitly define which cache tags trigger CloudFront invalidation
- **No Credential Management**: Relies on AWS SDK's built-in credential chain for security
