<?php

declare(strict_types=1);

namespace Drupal\cm_tools\Controller;

use Drupal\Component\Utility\Crypt;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\PageCache\ResponsePolicy\KillSwitch;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * A super simple controller for monitoring the uptime of the site.
 */
final class CmToolsMonitoringController extends ControllerBase {

  /**
   * The controller constructor.
   */
  public function __construct(
    private KillSwitch $pageCacheKillSwitch
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get('page_cache_kill_switch'),
    );
  }

  /**
   * The monitoring page callback.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   The response.
   */
  public function __invoke(): Response {
    $this->pageCacheKillSwitch->trigger();

    // Print something unlikely to be printed by e.g. Apache error pages.
    $output  = Crypt::hashBase64(__FUNCTION__ . cm_tools_get_uptime_path_token()) . "\n";
    $output .= date('c');

    return new Response($output);
  }

  /**
   * Access callback for the monitoring path.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(string $token): AccessResultInterface {
    if ($token === cm_tools_get_uptime_path_token()) {
      return AccessResult::allowed();
    }
    else {
      return AccessResult::forbidden();
    }
  }

}
