<?php

namespace Drupal\cms_content_sync\Plugin\rest\resource;

/**
 * Must define constants in separate interface instead of using the trait.
 */
interface ContentSyncRestInterface {
  /**
   * @var int CODE_OK All good
   */
  public const CODE_OK = 200;

  /**
   * @var int CODE_BAD_REQUEST The request is invalid
   */
  public const CODE_BAD_REQUEST = 400;

  /**
   * @var int CODE_INVALID_DATA The provided data could not be interpreted
   */
  public const CODE_INVALID_DATA = 401;

  /**
   * @var int CODE_NOT_FOUND The entity doesn't exist or can't be accessed
   */
  public const CODE_NOT_FOUND = 404;

  /**
   * @var int CODE_INTERNAL_SERVER_ERROR Unexpected error; try again later
   */
  public const CODE_INTERNAL_SERVER_ERROR = 500;

  /**
   * Respond with the given associative array as response body and the given
   * status code. Set $serialize to TRUE if this is a DELETE request where
   * Drupal will not apply regular serialization automatically.
   * Must be public because... PHP.
   *
   * @param array $body
   * @param int $status
   * @param bool $serialize
   */
  public function respondWith(array $body, int $status, bool $serialize);

}
