<?php

namespace Drupal\cms_content_sync\Controller;

use Drupal\cms_content_sync\Entity\Flow;
use Drupal\cms_content_sync\Entity\Pool;
use Drupal\cms_content_sync\Plugin\Type\EntityHandlerPluginManager;
use Drupal\cms_content_sync\PullIntent;
use Drupal\cms_content_sync\SyncCoreInterface\DrupalApplication;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Controller\ControllerBase;

/**
 * Provides a listing of Flow.
 */
class ManualPull extends ControllerBase {

  /**
   *
   */
  public static function hasAnyManualPullFlows() {
    static $has_any = NULL;

    if (NULL === $has_any) {
      $cache = \Drupal::cache();
      $cache_item = $cache->get(Flow::CACHE_ITEM_NAME_FLOWS);
      $cache_item_data = $cache_item ? $cache_item->data : NULL;

      if ($cache_item_data && isset($cache_item_data->hasAnyManualPull)) {
        $has_any = $cache_item_data->hasAnyManualPull;
      }
      else {
        $has_any = FALSE;
        $flows = Flow::getAll();
        foreach ($flows as $flow) {
          $pull_manually = $flow->getController()->getEntityTypesToPull(PullIntent::PULL_MANUALLY);
          if (!empty($pull_manually)) {
            $has_any = TRUE;

            break;
          }
        }

        if (!$cache_item_data) {
          $cache_item_data = new \stdClass();
        }
        $cache_item_data->hasAnyManualPull = $has_any;
        $cache->set(Flow::CACHE_ITEM_NAME_FLOWS, $cache_item_data, CacheBackendInterface::CACHE_PERMANENT, [Flow::CACHE_TAG_ANY_FLOW]);
      }
    }

    return $has_any;
  }

  /**
   * Access check.
   *
   * Ensure that the pull tab is just show if a flow exists which contains
   * and entity type that has its pull set to "manual".
   */
  public function access() {
    return AccessResult::allowedIf(self::hasAnyManualPullFlows())
      ->addCacheTags([Flow::CACHE_TAG_ANY_FLOW]);
  }

  /**
   * Render the content synchronization Angular frontend.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   * @throws \EdgeBox\SyncCore\Exception\SyncCoreException
   *
   * @return array
   *   Returns the rendered pull dashboard.
   */
  public function content() {
    $settings = ContentSyncSettings::getInstance();

    $embed = Embed::create(\Drupal::getContainer());

    return $embed->pullDashboard();
  }

}
