<?php

namespace Drupal\cms_content_sync\Controller;

use Drupal\cms_content_sync\Entity\Flow;
use Drupal\cms_content_sync\SyncCoreFlowExport;
use Drupal\cms_content_sync\SyncCoreInterface\SyncCoreFactory;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteSiteConfigRequestMode;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Pull controller.
 */
class SetFlowStatus extends ControllerBase {

  /**
   * Set flow status.
   *
   * @param mixed $cms_content_sync_flow
   *   The Content Sync Flow.
   */
  public function setStatus($cms_content_sync_flow) {
    /**
     * @var \Drupal\cms_content_sync\Entity\Flow $flow
     */
    $flow = \Drupal::entityTypeManager()
      ->getStorage('cms_content_sync_flow')
      ->load($cms_content_sync_flow);

    $flow->set('status', !$flow->status());

    $flow->save();

    Flow::applyOverrides($flow->id(), $flow);

    Flow::resetFlowCache();

    if (SyncCoreFactory::export(RemoteSiteConfigRequestMode::CS, FALSE)) {
      if ($flow->status()) {
        \Drupal::messenger()->addMessage($this->t('Your Flow %name has been activated and exported to the Sync Core.', ['%name' => $flow->label()]));
      }
      else {
        \Drupal::messenger()->addMessage($this->t('The Flow @flow_name has been deactivated and exported to the Sync Core.', ['@flow_name' => $flow->label()]));
      }
    }
    else {
      if ($flow->status()) {
        $exporter = new SyncCoreFlowExport($flow);
        $batch = $exporter->prepareBatch(FALSE);
        $batch->executeAll();

        \Drupal::messenger()->addMessage($this->t('Your Flow %name has been activated and exported to the Sync Core.', ['%name' => $flow->label()]));
      }
      else {
        \Drupal::messenger()->addMessage($this->t('The Flow @flow_name has been deactivated.', ['@flow_name' => $flow->label()]));
      }
    }

    SyncCoreFlowExport::deleteUnusedFlows();

    return new RedirectResponse(Url::fromRoute('entity.cms_content_sync_flow.collection')->toString());
  }

}
