<?php

namespace Drupal\cms_content_sync\Plugin\cms_content_sync\field_handler;

use Drupal\cms_content_sync\Plugin\EntityReferenceHandlerBase;
use Drupal\cms_content_sync\PushIntent;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Implements webform references.
 *
 * @FieldHandler(
 *   id = "cms_content_sync_default_webform_handler",
 *   label = @Translation("Default Webform"),
 *   weight = 90
 * )
 */
class DefaultWebformHandler extends EntityReferenceHandlerBase {

  /**
   * {@inheritdoc}
   */
  public static function supports($entity_type, $bundle, $field_name, FieldDefinitionInterface $field) {
    if (!in_array($field->getType(), ['webform'])) {
      return FALSE;
    }

    return TRUE;
  }

  /**
   * Don't expose option, but force push.
   *
   * @return bool
   */
  protected function forcePushingReferencedEntities() {
    return FALSE;
  }

  /**
   * @return bool
   */
  protected function allowPushingReferencedEntities() {
    return TRUE;
  }

  /**
   * Don't expose option, but force push.
   *
   * @return bool
   */
  protected function forceEmbeddingReferencedEntities() {
    return FALSE;
  }

  /**
   * @return string
   */
  protected function getReferencedEntityTypes() {
    return ['webform'];
  }

  /**
   * {@inheritDoc}
   */
  protected function getFieldValuesForReference(EntityInterface $reference, $intent, $value) {
    return [
      'target_id' => $reference->id(),
    ];
  }

  /**
   * @param $value
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   * @throws \Drupal\cms_content_sync\Exception\SyncException
   * @throws \GuzzleHttp\Exception\GuzzleException
   *
   * @return array|object
   */
  protected function serializeReference(PushIntent $intent, EntityInterface $reference, $value) {
    if ($this->shouldEmbedReferencedEntities()) {
      return $intent->embed($reference, $value);
    }
    if ($this->shouldPushReferencedEntities()) {
      return $intent->addDependency($reference, $value);
    }

    return $intent->addReference(
          $reference,
          $value
      );
  }

}
