<?php

namespace Drupal\cms_content_sync_custom_field_example\Plugin\cms_content_sync\entity_handler;

use Drupal\cms_content_sync\Plugin\cms_content_sync\entity_handler\DefaultTaxonomyHandler;

/**
 * Providing an entity handler for taxonomies that maps by name instead of
 * only UUID to avoid duplication for sites that were set up without Content
 * Sync from the beginning.
 *
 * @EntityHandler(
 *   id = "cms_content_sync_custom_taxonomy_handler",
 *   label = @Translation("Custom Taxonomy"),
 *   weight = 50
 * )
 */
class CustomTaxonomyHandler extends DefaultTaxonomyHandler {

  /**
   * {@inheritdoc}
   */
  public static function supports($entity_type, $bundle) {
    // You may want to do this by bundle instead, e.g.
    // return 'taxonomy_term' == $entity_type && 'tags' === $bundle;.
    return 'taxonomy_term' == $entity_type;
  }

  /**
   * {@inheritDoc}
   */
  protected function shouldMapByLabel() {
    return TRUE;
  }

}
