<?php

namespace Drupal\cms_content_sync_views\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Update status entities.
 */
class UpdateStatusEntities extends ControllerBase {

  /**
   * Batch process callback for module installation.
   *
   * Used toupdate status entities with the required reference.
   *
   * @param array $ids
   *   The IDs of the entiites to be updated.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public static function updateEntityReference(array $ids) {
    $status_entity_storage = \Drupal::entityTypeManager()->getStorage('cms_content_sync_entity_status');
    foreach ($ids as $id) {
      $status_info_entity = $status_entity_storage->load($id);
      $referenced_entity = \Drupal::service('entity.repository')
        ->loadEntityByUuid($status_info_entity->get('entity_type')->value, $status_info_entity->get('entity_uuid')->value);
      $status_info_entity->set('entity', $referenced_entity);
      $status_info_entity->save();
    }
  }

  /**
   * Batch finished callback.
   */
  public static function updateStatusEntitiesFinished() {
    \Drupal::messenger()->addMessage('Status Entities have been updated.');
  }

}
