<?php

namespace Drupal\cms_content_sync\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Push changes controller.
 */
class ShowUsage extends ControllerBase {
  public const DIALOG_WIDTH = 900;

  /**
   * Render method for show usage.
   *
   * @param mixed $entity
   *   The entity the usage should be shown for.
   * @param string $entity_type
   *   The entity type of the entity the ussage should be shown for.
   *
   * @return array
   *   The content array to theme the introduction
   */
  public function content($entity, $entity_type) {
    $entity = \Drupal::entityTypeManager()
      ->getStorage($entity_type)
      ->load($entity);

    $embed = new Embed();
    return $embed->entityStatus($entity);
  }

}
