<?php

namespace Drupal\cms_content_sync\Plugin\cms_content_sync\field_handler;

use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Default handler for Cohesion / Site Studio references.
 *
 * @FieldHandler(
 *   id = "cms_content_sync_default_cohesion_entity_reference_handler",
 *   label = @Translation("Default Cohesion Entity Reference"),
 *   weight = 90
 * )
 */
class DefaultCohesionEntityReferenceHandler extends DefaultEntityReferenceHandler {

  /**
   * {@inheritdoc}
   */
  public static function supports($entity_type, $bundle, $field_name, FieldDefinitionInterface $field) {
    return 'cohesion_entity_reference_revisions' == $field->getType();
  }

}
