(function ($) {

  'use strict';

  function applyAction(context, name) {
    $('#content-sync--push-changes-confirm .'+name, context).each(function () {
      var link = $(this);

      if (link.data("selection-option--processed")) {
        return;
      }
      link.data("selection-option--processed", true);

      function checkboxes(filter) {
        return link.parents(".pushable-translations").find(filter ? filter + " input.form-checkbox:enabled" : "input.form-checkbox:enabled");
      }

      link.click(function (e) {
        if(name==="select-all-action") {
          checkboxes().prop("checked", true);
        }
        else {
          checkboxes().prop("checked", false);

          if (name === "select-new-action" || name === "select-new-changed-action") {
            checkboxes(".entity-new").prop("checked", true);
          }
          if (name === "select-changed-action" || name === "select-new-changed-action") {
            checkboxes(".entity-changed").prop("checked", true);
          }
          if (name === "select-restore-action") {
            checkboxes(".default-checked").prop("checked", true);
          }
        }

        e.preventDefault();
        return false;
      });
    });
  }

  Drupal.behaviors.pushChangesConfirm = {
    attach: function (context, settings) {
      applyAction(context, "select-all-action");
      applyAction(context, "select-new-action");
      applyAction(context, "select-new-changed-action");
      applyAction(context, "select-changed-action");
      applyAction(context, "select-none-action");
      applyAction(context, "select-restore-action");
    }
  };

})(jQuery, drupalSettings);
