<?php

namespace Drupal\cognito;

/**
 * Interface CognitoTokenInterface.
 */
interface CognitoTokenInterface {

  /**
   * Stores current user's authentication tokens.
   *
   * @param array $authenticationResult
   *   The cognito authentication result.
   *
   * @return $this
   */
  public function setAuthTokens(array $authenticationResult);

  /**
   * Gets current user's access token. Expired token is refreshed.
   *
   * @param bool $forceRefresh
   *   (Optional) Force a refresh of the token.
   *
   * @return string|null
   *   The access token, or NULL if not found.
   */
  public function getAccessToken(bool $forceRefresh = false);

  /**
   * Gets current user's id token. Expired token is refreshed.
   *
   * @param bool $forceRefresh
   *   (Optional) Force a refresh of the token.
   *
   * @return string|null
   *   The id token, or NULL if not found.
   */
  public function getIdToken(bool $forceRefresh = false);

  /**
   * Admin method to get a user's access token.
   *
   * @param int $uid
   *   The Drupal user id.
   *
   * @return string|null
   *   The access token, or NULL if not found.
   */
  public function adminGetAccessToken($uid);

  /**
   * Admin method to delete a user's authentication tokens.
   *
   * @param int $uid
   *   The Drupal user id.
   *
   * @return $this
   */
  public function adminDeleteAuthTokens($uid);

}
