<?php

namespace Drupal\cognito_tests;

use Aws\Result;
use Drupal\cognito\Aws\CognitoBase;
use Drupal\cognito\Aws\CognitoResult;

/**
 * Implementation for testing.
 */
class NullCognito extends CognitoBase {

  /**
   * {@inheritdoc}
   */
  public function authorize($username, $password) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () use ($password) {
      return ($password === 'letmein' || $password === 'hunter2') ? new CognitoResult([
        'AuthenticationResult' => [
          'AccessToken' => '123',
          'IdToken' => '123',
        ],
      ]) : new CognitoResult([], new \Exception('Failed to login'));
    });
  }

  /**
   * {@inheritdoc}
   */
  public function refreshAccessToken($refreshToken) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function signUp($username, $password, $email, array $userAttributes = []) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {
      $result = new CognitoResult(
        new Result([
          'UserSub' => 'facade00-0001-0001-0001-' . rand(100000000000, 999999999999),
        ]),
      );
      return $result;
    });
  }

  /**
   * {@inheritdoc}
   */
  public function resendConfirmationCode($username) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function confirmSignup($username, $confirmCode) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function forgotPassword($username) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function confirmForgotPassword($username, $password, $confirmationCode) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function getUser($accessToken) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function updateUserAttributes($accessToken, array $userAttributes) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminEnableUser($username) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminDisableUser($username) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminSignup($username, $email, $messageAction = '', array $userAttributes = []) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {
      $result = new CognitoResult(
        new Result([
          'User' => [
            'Username' => 'facade00-0001-0001-0001-' . rand(100000000000, 999999999999),
          ],
        ]),
      );
      return $result;
    });
  }

  /**
   * {@inheritdoc}
   */
  public function changePassword($accessToken, $oldPassword, $newPassword) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminRespondToNewPasswordChallenge($username, $challengeType, $challengeAnswer, $session) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminInitiateAuth($username, $password) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminUpdateUserAttributes($username, $attributeName, $attributeValue) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function verifyUserAttribute($attributeName, $confirmationCode, $accessToken) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function getUserAttributeVerificationCode($attributeName, $accessToken) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * {@inheritdoc}
   */
  public function adminGetUser($username) {
    $this->logCall(__FUNCTION__, \func_get_args());
    return $this->wrap(function () {

    });
  }

  /**
   * Log calls.
   */
  protected function logCall($method, $args) {
    if (!\Drupal::hasContainer()) {
      return;
    }
    $calls = \Drupal::state()->get('cognito_tests_logged_calls', []);
    $calls[] = [$method, $args];
    \Drupal::state()->set('cognito_tests_logged_calls', $calls);
  }

  /**
   * Reset logging calls.
   */
  public function resetCalls() {
    \Drupal::state()->set('cognito_tests_logged_calls', []);
  }

  /**
   * Get test logging calls.
   */
  public function getCalls() {
    \Drupal::state()->resetCache();
    return \Drupal::state()->get('cognito_tests_logged_calls', []);
  }

}
