<?php

namespace Drupal\Tests\cognito\Functional;

/**
 * Test changing the user status as an admin.
 *
 * @group cognito
 */
class EmailFlowAdminStatusTest extends CognitoTestBase {

  /**
   * The user account.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $userAccount;

  /**
   * A theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    $this->userAccount = $this->createExternalUser();
  }

  /**
   * Test the successful login flow.
   */
  public function testAdminCanToggleUserStatus() {
    $adminUser = $this->createExternalUser([
      'administer permissions',
      'administer users',
      'access user profiles',
    ]);
    $this->drupalGet('/user/login');
    $this->submitForm([
      'mail' => $adminUser->getEmail(),
      'pass' => 'letmein',
    ], 'Log in');

    $user_edit_url = $this->userAccount->toUrl('edit-form');

    $this->drupalGet('<front>');
    $this->drupalGet($this->userAccount->toUrl());
    $this->drupalGet($user_edit_url);

    // Block an active user.
    $this->submitForm(['status' => 0], 'Save');
    $this->assertSession()->pageTextContains('Account disabled in Cognito');
    $this->drupalGet($user_edit_url);

    // Save an already blocked user and ensure no API calls.
    $this->submitForm(['status' => 0], 'Save');
    $this->assertSession()->pageTextNotContains('Account disabled in Cognito');
    $this->drupalGet($user_edit_url);

    // Activate the user.
    $this->submitForm(['status' => 1], 'Save');
    $this->assertSession()->pageTextContains('Account enabled in Cognito');
    $this->drupalGet($user_edit_url);

    // Saving an already active user does not make API calls.
    $this->submitForm(['status' => 1], 'Save');
    $this->assertSession()->pageTextNotContains('Account enabled in Cognito');
  }

}
