/**
 * @file
 * Colorbox module load js.
 */
(function ($, Drupal) {

  'use strict';

  Drupal.behaviors.initColorboxSimpleLoad = {
    attach: function (context, settings) {
      if (!$.isFunction($.colorbox) || typeof settings.colorbox === 'undefined') {
        return;
      }

      if (settings.colorbox.mobiledetect && window.matchMedia) {
        // Disable Colorbox for small screens.
        var mq = window.matchMedia('(max-device-width: ' + settings.colorbox.mobiledevicewidth + ')');
        if (mq.matches) {
          return;
        }
      }

      $.urlParams = function (url) {
        var p = {},
            e,
            a = /\+/g,  // Regex for replacing addition symbol with a space.
            r = /([^&=]+)=?([^&]*)/g,
            d = function (s) { return decodeURIComponent(s.replace(a, ' ')); },
            q = url.split('?');
        while (e = r.exec(q[1])) {
          e[1] = d(e[1]);
          e[2] = d(e[2]);
          switch (e[2].toLowerCase()) {
            case 'true':
            case 'yes':
              e[2] = true;
              break;
            case 'false':
            case 'no':
              e[2] = false;
              break;
          }
          if (e[1] == 'width') { e[1] = 'innerWidth'; }
          if (e[1] == 'height') { e[1] = 'innerHeight'; }
          p[e[1]] = e[2];
        }
        return p;
      };

      once('init-colorbox-load', '.colorbox-load', context).forEach(function(element) {
        var params = $.urlParams($(element).attr('href'));
        $(element).colorbox($.extend({}, settings.colorbox, params));
      });
    }
  };

})(jQuery, Drupal);
