<?php

namespace Drupal\combined_image_style_formatters\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\ProxyClass\File\MimeType\ExtensionMimeTypeGuesser;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\breakpoint\BreakpointManagerInterface;
use Drupal\combined_image_style_formatters\CombinedImageStyleFormatterTrait;
use Drupal\image\Plugin\Field\FieldFormatter\ImageFormatterBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Plugin for responsive image formatter.
 */
#[FieldFormatter(
  id: 'responsive_image_combined_image_style',
  label: new TranslatableMarkup('Responsive image (Combined image style)'),
  field_types: [
    'image',
  ],
)]
class ResponsiveImageFormatter extends ImageFormatterBase {

  use CombinedImageStyleFormatterTrait;

  /**
   * Constructs a ResponsiveImageFormatter object.
   *
   * @param string $plugin_id
   *   The plugin ID for the formatter.
   * @param mixed $plugin_definition
   *   The plugin definition.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition.
   * @param array $settings
   *   The formatter settings.
   * @param string $label
   *   The formatter label.
   * @param string $view_mode
   *   The view mode.
   * @param array $third_party_settings
   *   Third-party settings.
   * @param \Drupal\Core\Breakpoint\BreakpointManagerInterface $breakpointManager
   *   The breakpoint manager service.
   * @param \Drupal\Core\ProxyClass\File\MimeType\ExtensionMimeTypeGuesser $mimeTypeGuesser
   *   The extension MIME type guesser service.
   */
  public function __construct(
    string $plugin_id,
    $plugin_definition,
    FieldDefinitionInterface $field_definition,
    array $settings,
    string $label,
    string $view_mode,
    array $third_party_settings,
    protected BreakpointManagerInterface $breakpointManager,
    protected ExtensionMimeTypeGuesser $mimeTypeGuesser,
  ) {
    parent::__construct($plugin_id, $plugin_definition, $field_definition, $settings, $label, $view_mode, $third_party_settings);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $plugin_id,
      $plugin_definition,
      $configuration['field_definition'],
      $configuration['settings'],
      $configuration['label'],
      $configuration['view_mode'],
      $configuration['third_party_settings'],
      $container->get('breakpoint.manager'),
      $container->get('file.mime_type.guesser.extension')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];
    $files = $this->getEntitiesToView($items, $langcode);

    foreach ($files as $delta => $file) {
      $item = $items[$delta];
      $elements[$delta] = $this->viewElement($item, $file);
    }

    return $elements;
  }

}
