<?php

namespace Drupal\combined_image_style\Controller;

use Drupal\combined_image_style\Entity\CombinedImageStyle;
use Drupal\image\Controller\ImageStyleDownloadController as ImageStyleDownloadControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Defines a controller to deliver combined image styles.
 */
class ImageStyleDownloadController extends ImageStyleDownloadControllerBase {

  /**
   * Deliver a combined image response.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request object.
   * @param string $scheme
   *   The file scheme, defaults to 'private'.
   * @param string $image_styles
   *   The combined image styles.
   * @param string $required_derivative_scheme
   *   The required scheme for the derivative image.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   A response object.
   */
  public function deliverCombined(Request $request, string $scheme, $image_styles, string $required_derivative_scheme): Response {
    return $this->deliver($request, $scheme, CombinedImageStyle::fromName($image_styles), $required_derivative_scheme);
  }

}
