(function ($, Drupal) {
  Drupal.behaviors.comfyUIProgress = {
    attach: function (context, settings) {
      if (settings.comfyui_prompt_id) {
        const ws = new WebSocket('ws://127.0.0.1:8188/ws?promptId=' + settings.comfyui_prompt_id);
        
        ws.onmessage = function(event) {
          const data = JSON.parse(event.data);
          
          if (data.type === 'progress') {
            const percentage = (data.data.value / data.data.max) * 100;
            $('.comfyui-progress-bar').css('width', percentage + '%');
            $('.comfyui-progress-text').text(Math.round(percentage) + '%');
          }
          
          if (data.type === 'executing') {
            $('.comfyui-current-node').text('Executing: ' + data.data.node);
          }
        };
      }
    }
  };
})(jQuery, Drupal);
