<?php

namespace Drupal\comfyui_login\EventSubscriber;

use Drupal\comfyui_login\Service\ComfyUITokenService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\comfyui\Event\ComfyUIRequestEvent;

/**
 * Event subscriber for ComfyUI requests.
 */
class ComfyUIRequestSubscriber implements EventSubscriberInterface {

  /**
   * The token service.
   *
   * @var \Drupal\comfyui_login\Service\ComfyUITokenService
   */
  protected $tokenService;

  /**
   * Constructs a ComfyUIRequestSubscriber.
   */
  public function __construct(ComfyUITokenService $token_service) {
    $this->tokenService = $token_service;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    // This would be used if we create an event system
    // For now, we'll use direct service calls
    return [];
  }

}
