<?php

namespace Drupal\comfyui\Plugin\ComfyUIOutputHandler;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Handles data value outputs from ComfyUI.
 *
 * @ComfyUIOutputHandler(
 *   id = "data_value_handler",
 *   label = @Translation("ComfyUI Data Value Handler"),
 *   output_types = {"data_value"}
 * )
 */
class ComfyUIDataValueHandler extends PluginBase implements ComfyUIOutputHandlerInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function processForPreview($output_data, $field_definition) {
    $preview_text = is_string($output_data) ? $output_data : json_encode($output_data);
    
    return [
      'type' => 'text_preview',
      'preview_text' => $preview_text,
      'can_save' => TRUE,
      'save_label' => $this->t('Save Text'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function processForSave($output_data, $field_definition, $save_options = []) {
    $field_type = $field_definition->getType();
    
    if (in_array($field_type, ['string', 'string_long', 'text', 'text_long'])) {
      $value = is_string($output_data) ? $output_data : json_encode($output_data);
      return ['value' => $value];
    }
    
    if ($field_type === 'integer' && is_numeric($output_data)) {
      return ['value' => (int) $output_data];
    }
    
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getRecommendedFormatters() {
    return [
      'string' => ['string', 'text_trimmed'],
      'text' => ['text_default'],
      'integer' => ['number_integer'],
    ];
  }

}
