<?php

namespace Drupal\comfyui\Plugin\ComfyUIOutputHandler;

/**
 * Interface for ComfyUI output handlers.
 */
interface ComfyUIOutputHandlerInterface {

  /**
   * Process ComfyUI output for preview display.
   *
   * @param mixed $output_data
   *   The raw output data from ComfyUI.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The target field definition.
   *
   * @return array
   *   Processed data for preview display.
   */
  public function processForPreview($output_data, $field_definition);

  /**
   * Process ComfyUI output for saving to Drupal field.
   *
   * @param mixed $output_data
   *   The raw output data from ComfyUI.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The target field definition.
   * @param array $save_options
   *   Additional save options.
   *
   * @return array|null
   *   Field value array or NULL if cannot save.
   */
  public function processForSave($output_data, $field_definition, $save_options = []);

  /**
   * Get display formatter recommendations for this output type.
   *
   * @return array
   *   Array of recommended formatters keyed by field type.
   */
  public function getRecommendedFormatters();

}
