<?php

namespace Drupal\comfyui\Plugin\ComfyUIOutputHandler;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Handles video file outputs from ComfyUI.
 *
 * @ComfyUIOutputHandler(
 *   id = "video_file_handler",
 *   label = @Translation("ComfyUI Video File Handler"),
 *   output_types = {"video_file"}
 * )
 */
class ComfyUIVideoFileHandler extends PluginBase implements ComfyUIOutputHandlerInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function processForPreview($output_data, $field_definition) {
    if (!isset($output_data['filename'])) {
      return [
        'type' => 'error',
        'message' => 'No filename in video output data',
      ];
    }

    return [
      'type' => 'video_preview',
      'preview_url' => "/comfyui/video-proxy/{$output_data['filename']}",
      'metadata' => $output_data,
      'can_save' => TRUE,
      'save_label' => $this->t('Save Video'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function processForSave($output_data, $field_definition, $save_options = []) {
    $field_type = $field_definition->getType();
    
    if ($field_type === 'link') {
      return [
        'uri' => "/comfyui/video-proxy/{$output_data['filename']}",
        'title' => 'Generated Video',
      ];
    }
    
    if (in_array($field_type, ['string', 'string_long'])) {
      return [
        'value' => "/comfyui/video-proxy/{$output_data['filename']}",
      ];
    }
    
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getRecommendedFormatters() {
    return [
      'link' => ['comfyui_link_video'],
      'string' => ['basic_string'],
    ];
  }

}
