<?php

namespace Drupal\comfyui\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'random_seed' widget.
 *
 * @FieldWidget(
 *   id = "random_seed",
 *   label = @Translation("Random Seed Generator"),
 *   field_types = {
 *     "integer"
 *   }
 * )
 */
class ComfyUIRandomSeedWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    // Get existing value or generate random if empty
    $value = isset($items[$delta]->value) ? $items[$delta]->value : $this->generateRandomSeed();
    
    // Get the field name for data attribute
    $field_name = $this->fieldDefinition->getName();
    
    $element += [
      '#type' => 'number',
      '#default_value' => $value,
      '#min' => 1,
      '#max' => 999999,
      '#size' => 8,
      '#attributes' => [
        'class' => ['comfyui-seed-field'],
        'data-comfyui-field' => $field_name,
      ],
      '#description' => $this->t('Seed value for reproducible generation. Use the controls below to manage seed behavior.'),
      '#attached' => [
        'library' => ['comfyui/seed_manager'], // Load seed-specific JS
      ],
    ];

    return $element;
  }

  /**
   * Generate a random seed value.
   */
  protected function generateRandomSeed() {
    return mt_rand(100000, 999999);
  }

}
