<?php

namespace Drupal\comfyui\Service;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Helper service for ComfyUI file scheme configuration.
 */
class ComfyUIFileSchemeHelper {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs helper.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * Get the configured file scheme for ComfyUI files.
   *
   * @return string
   *   'public' or 'private'
   */
  public function getFileScheme() {
    $config = $this->configFactory->get('comfyui.settings');
    return $config->get('comfyui_file_scheme') ?? 'public';
  }

  /**
   * Get the full directory URI for input images.
   *
   * @return string
   *   e.g., 'public://comfyui/input/2024-11'
   */
  public function getInputDirectory() {
    $scheme = $this->getFileScheme();
    $directory = $scheme . '://comfyui/input/' . date('Y-m');
    
    // Ensure directory exists
    \Drupal::service('file_system')->prepareDirectory(
      $directory,
      \Drupal\Core\File\FileSystemInterface::CREATE_DIRECTORY | 
      \Drupal\Core\File\FileSystemInterface::MODIFY_PERMISSIONS
    );
    
    return $directory;
  }

  /**
   * Get the full directory URI for generated images.
   *
   * @return string
   *   e.g., 'public://comfyui/generated/2024-11'
   */
  public function getGeneratedDirectory() {
    $scheme = $this->getFileScheme();
    $directory = $scheme . '://comfyui/generated/' . date('Y-m');
    
    // Ensure directory exists
    \Drupal::service('file_system')->prepareDirectory(
      $directory,
      \Drupal\Core\File\FileSystemInterface::CREATE_DIRECTORY | 
      \Drupal\Core\File\FileSystemInterface::MODIFY_PERMISSIONS
    );
    
    return $directory;
  }

}
