# Comment Tracker

The **Comment Tracker** module provides lightweight per-user tracking of viewed comments. It allows themes and site builders to show indicators for new comments on both nodes and individual comments. The module is designed for performance, clean theming, and minimal configuration.

---

## What This Module Does

* Tracks when an authenticated user views a comment.
* Stores tracking records containing `viewer_uid`, `comment_id`, and a timestamp.
* Exposes aggregated comment statistics to Twig:

  * Number of new/unread comments
  * Number of read comments
  * Total comment count
* Provides simple CSS hooks for “new comment” indicators.
* Includes JavaScript that automatically removes the indicator classes once a comment is registered as read.

This module does not modify Drupal’s comment system; it only adds a tracking layer on top of it.

---

## Available Twig Variables

### For Comments

In `comment.html.twig`:

```
$variables['comment_stats'] = $stats;
```

`comment_stats` contains:

* `comment_stats.new` — `1` if the current user has not viewed the comment
* `comment_stats.read` — `1` if the user has viewed the comment
* `comment_stats.total` — always `1` for an individual comment
* `comment_stats.timestamp` — when the user viewed the comment (if applicable)

---

### For Nodes

In `node.html.twig`:

```
$variables['comment_stats'] = $stats;
```

For nodes, the module aggregates all comment information:

* `comment_stats.new` — number of unread comments on the node
* `comment_stats.read` — number of read comments
* `comment_stats.total` — total comments
* `comment_stats.unread` — alias of `new`

---

## CSS Classes

The following classes can be used in Twig. Module-provided JavaScript will automatically remove them after the user has viewed the corresponding comments.

* `comment-tracker-indicator__new_comment`
* `comment-tracker__comment_stats`

These can be applied to badges, counters, bubbles, wrappers, or any UI element you want to highlight unread comments.

---

## Example Twig Usage

### Comment-Level Indicator

```twig
{% if comment_stats.new %}
  <span class="comment-tracker-indicator__new_comment">
    New
  </span>
{% endif %}
```

### Node-Level Comment Counter

```twig
{% if comment_stats.new > 0 %}
  <div class="comment-tracker__comment_stats">
    {{ comment_stats.new }}
  </div>
{% endif %}
```

---

## How It Works

* When a comment is viewed, a tracking entity is created or updated for the current user.
* Tracking is stored as `(viewer_uid, comment_id, viewed_at)`.
* Statistics are calculated by a dedicated service.
* Twig variables are injected through preprocess hooks.
* JavaScript removes the indicator classes once comments are marked as viewed.

---

## Requirements

* Drupal 10.x
* Comment module enabled

## MAINTAINERS

Current maintainers for Drupal 10:

- PAUL MRVIK (globexplorer) - https://www.drupal.org/u/globexplorer
