(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.commentTracker = {
    attach: function (context, settings) {
      const comments = drupalSettings.comment_tracker?.comments;
      const currentUid = drupalSettings.comment_tracker?.current_uid;

      if (!comments) return;

      Object.values(comments).forEach(c => {
        // Skip own comments
        if (c.authorUid && c.authorUid == currentUid) return;

        const elements = once('comment-tracker', '#comment-' + c.id, context);
        elements.forEach(el => {
          // Intersection Observer
          const observer = new IntersectionObserver((entries, obs) => {
            entries.forEach(entry => {
              if (entry.isIntersecting) {
                // Wait 5 seconds while in viewport
                setTimeout(() => {
                  fetch(c.markUrl, {
                    method: 'GET',
                    credentials: 'same-origin'
                  })
                    .then(r => r.json())
                    .then(() => {
                      el.classList.add('comment-read');

                      const badge = el.querySelector('.comment-tracker-indicator__new_comment');
                      if (badge) badge.remove();

                      const nodeArticle = el.closest('article[data-history-node-id]');
                      if (nodeArticle) {
                        const stats = nodeArticle.querySelector('.comment-tracker__comment_stats');
                        if (stats) stats.remove();
                      }
                    });
                }, 5000); // 5000ms = 5 seconds

                // Stop observing after first trigger
                obs.unobserve(el);
              }
            });
          }, {
            threshold: 0.5 // comment is at least 50% visible
          });

          observer.observe(el);
        });
      });
    }
  };
})(Drupal, drupalSettings, once);
