<?php

namespace Drupal\comment_tracker\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class CommentTrackerController extends ControllerBase {

  public function markRead(Request $request): JsonResponse {
    $uid = (int) $this->currentUser()->id();
    if (!$uid) {
      return new JsonResponse(['status' => 'denied'], 403);
    }

    $comment_id = (int) $request->query->get('comment_id');
    if (!$comment_id) {
      return new JsonResponse(['status' => 'missing comment_id'], 400);
    }

    $comment = $this->entityTypeManager()->getStorage('comment')->load($comment_id);
    if (!$comment) {
      return new JsonResponse(['status' => 'not found'], 421);
    }

    /** @var \Drupal\comment_tracker\CommentTrackerManager $manager */
    $manager = \Drupal::service('comment_tracker.manager');
    $manager->markCommentRead($comment);

    return new JsonResponse(['status' => 'ok']);
  }
  
}
